﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    //create an instance of the appt collection with page level scope
    clsApptsCollection Appts;
    protected void Page_Load(object sender, EventArgs e)
    {
        //if this is the first time the page has been displayed
        if (IsPostBack == false)
        {
            //initialise the list of appointments for sepcified date
            Appts = new clsApptsCollection(Convert.ToDateTime(txtApptDate.Text));
            //display the appts in th elist
            DisplayAppts();
        }
        else //if this is a re-load of the page
        {
            //read in the already initialised list
            Appts = (clsApptsCollection)Session["Appts"];
        }
    }

    protected void Page_UnLoad(object sender, EventArgs e)
    {
        //store the appt list in the session object
        Session["Appts"] = Appts;
    }


    protected void btnGo_Click(object sender, EventArgs e)
    {
        //reinitialise the list of appt with the new date
        Appts = new clsApptsCollection(Convert.ToDateTime(txtApptDate.Text));
        //dislay the list of appts
        DisplayAppts();
    }

    void DisplayAppts()
    {
        //function displays the list of appointments in the list box

        //var to store the appt no if an existing appointment it is the primary key
        //if it is an available appt it is the time prefied with -
        Int32 ApptNo;
        //var to store the appt time
        Int32 ApptTime;
        //var to store the appt reason
        string ApptReason;
        //index for the loop
        Int32 Index = 0;
        //clear the list of any existing entries
        lstAppts.Items.Clear();
        //loop for processing the appts
        while (Index < Appts.Count)
        {
            //get the appt no
            ApptNo = Appts.Appts[Index].ApptNo;
            //get the appt time
            ApptTime = Appts.Appts[Index].ApptTime;
            //get the appt reason
            ApptReason = Appts.Appts[Index].ApptReason;
            //create the appt entry
            ListItem NewItem = new ListItem("Primary key " + ApptNo.ToString() + "Time " + ApptTime.ToString() + " " + ApptReason, ApptNo.ToString());
            //add the appt to the list
            lstAppts.Items.Add(NewItem);
            //inc the index
            Index++;
        }
    }


    protected void btnBook_Click(object sender, EventArgs e)
    {
        //var to store the booking time
        string BookingTime;
        //var to store the booking date
        string BookingDate;
        //clear amu previous errors
        lblError.Text = "";
        //check to see that an entry has been selected
        if (lstAppts.SelectedIndex != -1)
        {
            //read in the primary key
            BookingTime = lstAppts.SelectedValue;
            //get the booking date
            BookingDate = txtApptDate.Text;
            //if this is an available appt eg - at the start
            if (BookingTime.Contains("-") == true)
            {
                //redirect to the make booking page
                Response.Redirect("MakeBooking.aspx?BookingDate=" + BookingDate + "&BookingTime=" + BookingTime);
            }
            else//otherwise cannot change the appt (at least in this version of the system)
            {
                lblError.Text = "Cannot change this booking";
            }
        }
        else //show an error if not
        {
            lblError.Text = "You must select an avaiable booking first";
        }
    }
}